﻿##
uses School;

procedure Solve(num: integer);
begin
    // печатаем результаты в консольном окне:
    println;
    println($' Число {num} делится на:');
    for var i := 1 to num do
       if (num mod i = 0) then
           print(i + ' ');
    println;
    println;
end;

// ОПТИМИЗИРОВАННАЯ ФУНКЦИЯ
procedure SolveOpt(num: integer);
begin
    // печатаем результаты в консольном окне:
    println;
    println($' Число {num} делится на:');
    for var i := 1 to num div 2 + 1 do
       if (num mod i = 0) then
           print(i + ' ');
    println(num);
    println;
end;


// ОПТИМИЗИРОВАННАЯ ФУНКЦИЯ СО СПИСКОМ
procedure SolveList(num: integer);
begin
   // список для записи делителей:
   var res := new List<integer>();

    foreach var i in Range(1, Integer(num.Sqrt + 1)) do begin   
       if (num mod i = 0) then begin
           res.Add(i);
           // не допускаем повторов делителей:
           if (i * i <> num) then
               res.Add(num div i)
       end;
    end;
    res.Sort;
    // печатаем результаты в консольном окне:
    println;
    println($' Число {num} делится на:');
    foreach var n in res do
       print(n + ' '); 
    println;
    println;    
end;


procedure SolveSchool(num: integer);
begin
   // список делителей:
   var res := Divisors(num);

   // печатаем результаты в консольном окне:
   println($' Число {num} делится на:');
   res.println;
   println;    
end;


function DivisorGenerator(num : integer): sequence of integer;
begin
   foreach var i in Range(1, num div 2 + 1) do
      if num mod i = 0 then
         yield i;
   yield num;
end;

procedure SolveGen(num: integer);
begin
   // печатаем результаты в консольном окне:
   println($' Число {num} делится на:');
   foreach var n in DivisorGenerator(num) do
      print(n);
   println;  
   println;    
end;


WriteLn(' Делится - не делится?');
WriteLn;  
   
// бесконечный цикл ввода данных - 
// пока пользователь не закроет программу:
repeat
   var num := ReadInteger(' Введите натуральное число  >');      
   //Solve(num); 
   //SolveOpt(num);    
   //SolveList(num);  
   //SolveSchool(num); 
   SolveGen(num);    
until not (true);
